Imports System.ComponentModel


Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents EventLog1 As System.Diagnostics.EventLog
  Friend WithEvents MainMenu1 As System.Windows.Forms.MainMenu
  Friend WithEvents MenuItem1 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem2 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem3 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem4 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem5 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem6 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem7 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem8 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem9 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem10 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem17 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem18 As System.Windows.Forms.MenuItem
  Friend WithEvents TextBox1 As System.Windows.Forms.TextBox
  Friend WithEvents MenuItem11 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem12 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem13 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem14 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem15 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem16 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem19 As System.Windows.Forms.MenuItem
  Friend WithEvents MenuItem20 As System.Windows.Forms.MenuItem
    
  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.MenuItem19 = New System.Windows.Forms.MenuItem()
    Me.MenuItem18 = New System.Windows.Forms.MenuItem()
    Me.MenuItem15 = New System.Windows.Forms.MenuItem()
    Me.MenuItem16 = New System.Windows.Forms.MenuItem()
    Me.MenuItem20 = New System.Windows.Forms.MenuItem()
    Me.MenuItem14 = New System.Windows.Forms.MenuItem()
    Me.MenuItem17 = New System.Windows.Forms.MenuItem()
    Me.MenuItem11 = New System.Windows.Forms.MenuItem()
    Me.MenuItem10 = New System.Windows.Forms.MenuItem()
    Me.MenuItem13 = New System.Windows.Forms.MenuItem()
    Me.MenuItem12 = New System.Windows.Forms.MenuItem()
    Me.TextBox1 = New System.Windows.Forms.TextBox()
    Me.EventLog1 = New System.Diagnostics.EventLog()
    Me.MainMenu1 = New System.Windows.Forms.MainMenu()
    Me.MenuItem1 = New System.Windows.Forms.MenuItem()
    Me.MenuItem2 = New System.Windows.Forms.MenuItem()
    Me.MenuItem5 = New System.Windows.Forms.MenuItem()
    Me.MenuItem6 = New System.Windows.Forms.MenuItem()
    Me.MenuItem7 = New System.Windows.Forms.MenuItem()
    Me.MenuItem8 = New System.Windows.Forms.MenuItem()
    Me.MenuItem9 = New System.Windows.Forms.MenuItem()
    Me.MenuItem3 = New System.Windows.Forms.MenuItem()
    Me.MenuItem4 = New System.Windows.Forms.MenuItem()
    CType(Me.EventLog1, System.ComponentModel.ISupportInitialize).BeginInit()
    Me.SuspendLayout()
    '
    'MenuItem19
    '
    Me.MenuItem19.Index = 1
    Me.MenuItem19.Text = "&System"
    '
    'MenuItem18
    '
    Me.MenuItem18.Index = 7
    Me.MenuItem18.Text = "Event Entry Notification"
    '
    'MenuItem15
    '
    Me.MenuItem15.Index = 11
    Me.MenuItem15.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem16, Me.MenuItem19, Me.MenuItem20})
    Me.MenuItem15.Text = "&View Log"
    '
    'MenuItem16
    '
    Me.MenuItem16.Index = 0
    Me.MenuItem16.Text = "&Application"
    '
    'MenuItem20
    '
    Me.MenuItem20.Index = 2
    Me.MenuItem20.Text = "S&ecurity"
    '
    'MenuItem14
    '
    Me.MenuItem14.Index = 10
    Me.MenuItem14.Text = "Fill Custom Log"
    '
    'MenuItem17
    '
    Me.MenuItem17.Index = 6
    Me.MenuItem17.Text = "-"
    '
    'MenuItem11
    '
    Me.MenuItem11.Index = 8
    Me.MenuItem11.Text = "-"
    '
    'MenuItem10
    '
    Me.MenuItem10.Index = 5
    Me.MenuItem10.Text = "Get List of Logs"
    '
    'MenuItem13
    '
    Me.MenuItem13.Index = 2
    Me.MenuItem13.Text = "Delete &Log"
    '
    'MenuItem12
    '
    Me.MenuItem12.Index = 9
    Me.MenuItem12.Text = "Iterate Logs"
    '
    'TextBox1
    '
    Me.TextBox1.Dock = System.Windows.Forms.DockStyle.Fill
    Me.TextBox1.Multiline = True
    Me.TextBox1.Name = "TextBox1"
    Me.TextBox1.Size = New System.Drawing.Size(472, 424)
    Me.TextBox1.TabIndex = 0
    Me.TextBox1.Text = ""
    Me.TextBox1.WordWrap = False
    '
    'EventLog1
    '
    Me.EventLog1.EnableRaisingEvents = True
    Me.EventLog1.Log = "System"
    Me.EventLog1.Source = "Demo"
    Me.EventLog1.SynchronizingObject = Me
    '
    'MainMenu1
    '
    Me.MainMenu1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem1, Me.MenuItem5, Me.MenuItem3})
    '
    'MenuItem1
    '
    Me.MenuItem1.Index = 0
    Me.MenuItem1.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem2})
    Me.MenuItem1.Text = "&File"
    '
    'MenuItem2
    '
    Me.MenuItem2.Index = 0
    Me.MenuItem2.Text = "E&xit"
    '
    'MenuItem5
    '
    Me.MenuItem5.Index = 1
    Me.MenuItem5.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem6, Me.MenuItem7, Me.MenuItem13, Me.MenuItem8, Me.MenuItem9, Me.MenuItem10, Me.MenuItem17, Me.MenuItem18, Me.MenuItem11, Me.MenuItem12, Me.MenuItem14, Me.MenuItem15})
    Me.MenuItem5.Text = "&Demo"
    '
    'MenuItem6
    '
    Me.MenuItem6.Index = 0
    Me.MenuItem6.Text = "&Create Event Source"
    '
    'MenuItem7
    '
    Me.MenuItem7.Index = 1
    Me.MenuItem7.Text = "&Delete Event Source"
    '
    'MenuItem8
    '
    Me.MenuItem8.Index = 3
    Me.MenuItem8.Text = "-"
    '
    'MenuItem9
    '
    Me.MenuItem9.Index = 4
    Me.MenuItem9.Text = "&Write Entry"
    '
    'MenuItem3
    '
    Me.MenuItem3.Index = 2
    Me.MenuItem3.MenuItems.AddRange(New System.Windows.Forms.MenuItem() {Me.MenuItem4})
    Me.MenuItem3.Text = "&Help"
    '
    'MenuItem4
    '
    Me.MenuItem4.Index = 0
    Me.MenuItem4.Text = "&About"
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
    Me.ClientSize = New System.Drawing.Size(472, 424)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.TextBox1})
    Me.Menu = Me.MainMenu1
    Me.Name = "Form1"
    Me.Text = "Event Log Demo"
    CType(Me.EventLog1, System.ComponentModel.ISupportInitialize).EndInit()
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub EventLog1_EntryWritten(ByVal sender As System.Object, ByVal e As System.Diagnostics.EntryWrittenEventArgs) Handles EventLog1.EntryWritten
    MsgBox(sender.GetType.Name)
  End Sub

  Private Sub MenuItem4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem4.Click
    About.ShowAbout()
  End Sub

  Private Sub MenuItem2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem2.Click
    Application.Exit()
  End Sub

  Private Sub MenuItem6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem6.Click
    EventLogClass.CreateEventSource()
  End Sub

  Private Sub MenuItem7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem7.Click
    EventLogClass.DeleteEventSource()
  End Sub

  Private Sub MenuItem9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem9.Click
    EventLogClass.WriteEntry(InputBox("Enter text to write to the event log:", "Write to EventLog"))
  End Sub

  Private Sub AddLogText(ByVal Log As EventLog)
    TextBox1.Text = TextBox1.Text & _
      Log.LogDisplayName & vbCrLf
  End Sub

  Private Sub MenuItem10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem10.Click
    TextBox1.Clear()
    Dim Enumerator As IEnumerator = _
      EventLogClass.GetList().GetEnumerator

    While (Enumerator.MoveNext)
      AddLogText(Enumerator.Current)
    End While

  End Sub

  Private Sub MenuItem18_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem18.Click
    EventLog1.WriteEntry(Now)
  End Sub

  Private Sub MenuItem12_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem12.Click
    EventLogClass.IterateLogs()
  End Sub

  Private Sub MenuItem13_Click_1(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem13.Click
    Dim Value As String
    Value = InputBox("Enter log to delete:", "Delete Log")
    If (Value <> "") Then
      EventLogClass.Delete(Value)
    End If
  End Sub

  Private Sub Form1_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Load
    If (Not EventLog.SourceExists("EventLogDemo")) Then
      EventLog.CreateEventSource("EventLogDemo", "Application")
      EventLog.WriteEntry("EventLogDemo", "Created Source", EventLogEntryType.Information)
    End If
  End Sub

  Private Sub MenuItem14_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem14.Click
    Const SourceName As String = "FullLog"

    If (Not EventLog.SourceExists(SourceName)) Then
      EventLog.CreateEventSource(SourceName, "FullLog")
    End If

    While True

      EventLog.WriteEntry(SourceName, Now)

    End While

  End Sub

  Private Sub DisplayEntries(ByVal LogName As String)

    If (Not EventLog.Exists(LogName)) Then Exit Sub

    TextBox1.Clear()
    Dim Log As New EventLog(LogName)
    Try

      Dim Entry As EventLogEntry
      For Each Entry In Log.Entries
        TextBox1.Text = TextBox1.Text & Entry.Message & _
          vbCrLf
      Next

    Finally
      Log = Nothing
    End Try

  End Sub

  Private Sub MenuItem16_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem16.Click
    DisplayEntries("Application")
  End Sub

  Private Sub MenuItem19_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem19.Click
    DisplayEntries("System")
  End Sub

  Private Sub MenuItem20_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MenuItem20.Click
    DisplayEntries("Security")
  End Sub
End Class

Public Class EventLogClass
  Private Const SourceName = "MyLog"

  Private Shared Function SourceExists() As Boolean
    Return EventLog.SourceExists(SourceName)
  End Function

  Public Shared Sub CreateEventSource()
    If (Not SourceExists()) Then
      EventLog.CreateEventSource(SourceName, "Security")
    Else
      MsgBox("Source exists", MsgBoxStyle.Exclamation, _
        "Event Log Demo")
    End If
  End Sub

  Public Shared Sub DeleteEventSource()
    If (SourceExists()) Then
      EventLog.DeleteEventSource(SourceName)
    Else
      MsgBox("Source does not exist", MsgBoxStyle.Exclamation, _
        "Event Log Demo")
    End If
  End Sub

  Private Shared Sub CheckSource()
    If (Not SourceExists()) Then
      CreateEventSource()
    End If
  End Sub

  Public Shared Sub WriteEntry(ByVal Message As String)
    CheckSource()
    EventLog.WriteEntry(SourceName, Message)
  End Sub

  Public Shared Function GetList() As EventLog()
    Return EventLog.GetEventLogs()
  End Function


  Public Shared Sub IterateLogs()
    Dim Logs() As EventLog = EventLog.GetEventLogs()
    Debug.WriteLine(Logs.GetType.BaseType.Name)
    Dim Enumerator As IEnumerator = Logs.GetEnumerator

    While Enumerator.MoveNext

      Debug.WriteLine(CType(Enumerator.Current, _
        EventLog).LogDisplayName)
    End While
  End Sub

  Private Shared Function IsSystemLog(ByVal Log As String) As Boolean
    Return Log.Equals("System") Or Log.Equals("Application") _
      Or Log.Equals("Security")
  End Function

  Private Shared Function Prompt(ByVal Log As String) As String
    Return _
      String.Format("Warning deleting {0} is not recommended. Are you sure?", Log)
  End Function

  Private Shared Function DeleteLog(ByVal Log As String) As Boolean
    Return MsgBox(Prompt(Log), MsgBoxStyle.Question + MsgBoxStyle.YesNo, _
      "Delete Event Log") = MsgBoxResult.Yes
  End Function

  Private Shared Function Deletable(ByVal Log As String) As Boolean
    If (IsSystemLog(Log)) Then
      Return DeleteLog(Log)
    End If
    Return True
  End Function

  Private Shared Function Message(ByVal Log As String) As String
    Return _
      String.Format("Call EventLog.Delete({0}) to delete the log file.", Log)
  End Function

  Public Shared Sub Delete(ByVal Log As String)
    If (Deletable(Log)) Then
      'EventLog.Delete(Log) 
      MsgBox(Message(Log))
    End If
  End Sub

End Class

Public Class About
  Private Shared Function AboutMessage() As String
    Return "Event Log Demo" & vbCrLf & _
      "Sams Visual Basic.Net Unleashed" & vbCrLf & _
      "Copyright (c) 2001. All Rights Reserved." & vbCrLf & _
      "By Paul Kimmel. pkimmel@softconcepts.com"
  End Function

  Public Shared Sub ShowAbout()
    MessageBox.Show(AboutMessage(), "About", _
      MessageBoxButtons.OK, MessageBoxIcon.Information)
  End Sub
End Class

